# Ledger & Lane Accounting - Free Website Template

A clean, professional website template designed for accounting firms, tax preparation services, bookkeepers, and financial advisory practices.

## Pages Included

- **Home** (`index.html`) - Hero, services overview, why choose us, stats, testimonials, CTA
- **About** (`about.html`) - Company story, team profiles, approach, credentials
- **Services** (`services.html`) - Detailed service offerings with pricing, process steps
- **Contact** (`contact.html`) - Contact form, office info, hours, FAQ

## Quick Start

1. Download and unzip the template
2. Open `index.html` in your browser to preview
3. Edit the HTML files with your own content
4. Replace placeholder text with your firm's information
5. Upload to your web hosting provider

## Customization

### Colors

All colors are defined as CSS custom properties in `styles.css`. Change the values in the `:root` section:

```css
:root {
  --primary: #1B4D5C;      /* Deep teal */
  --accent: #D97706;        /* Amber/gold */
  --secondary: #475569;     /* Warm slate */
  --light-bg: #F8FAFC;      /* Light background */
  --dark: #1E293B;          /* Dark text */
}
```

### Fonts

The template uses Google Fonts:
- **DM Serif Display** - Headings
- **Source Sans 3** - Body text

To change fonts, update the Google Fonts link in the `<head>` and the CSS custom properties.

### Content

Replace all placeholder content with your own:
- Firm name and contact details
- Team member names, titles, and descriptions
- Service descriptions and pricing
- Testimonials
- Office hours and location

### Images

Photo placeholders use colored gradient backgrounds. Replace the `.story-image`, `.team-photo`, and similar elements with actual images by adding `background-image: url('your-image.jpg')` or using `<img>` tags.

## Features

- Responsive design (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS custom properties for easy theming
- Font Awesome 6.5 icons
- Clean, semantic HTML5
- No JavaScript frameworks required
- Accessible (ARIA labels, semantic elements)

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## License

Free for personal and commercial use. Attribution appreciated but not required.

Design by [ZADIE](https://zadie.com)
