# The Copper Rail Pub — Free Website Template

A dark, warm neighborhood pub website template. Dark wood tones, amber accents, chalkboard-style sections. Built for bars, pubs, and taverns that want a site with real character.

## License

Free to use for any personal or commercial project. Attribution appreciated but not required.

## Quick Start

1. Download and unzip
2. Open `index.html` in your browser to preview
3. Edit content directly in the HTML files
4. Replace placeholder colors/gradients with real photos

## Pages

- `index.html` — Homepage with hero, featured beers, events overview, testimonials
- `about.html` — Pub history, team, the space
- `services.html` — Full food and drinks menu, weekly events, private hire info
- `contact.html` — Table reservations, private hire enquiry, FAQ, map

## Customization

### Business Details
Search and replace throughout all HTML files:
- `The Copper Rail` → Your pub name
- `142 Marlowe Street, East Village, New York, NY 10009` → Your address
- `(212) 555-0194` → Your phone number
- `hello@copperpub.com` → Your email
- `Est. 1987` → Your year

### Colors
Edit CSS variables in `styles.css` under `:root`:
- `--primary` — Amber/gold (#D97706)
- `--secondary` — Dark wood brown (#78350F)
- `--accent` — Tap red (#DC2626)
- `--bg` — Deep dark background (#0F0A06)

### Fonts
Loaded from Google Fonts:
- **Abril Fatface** — Headings
- **Barlow** — Body text

### Photos
Replace the placeholder gradient divs (`.hero-img`, `.team-photo`, `.space-img`) with `<img>` tags pointing to your photos.

## Built With

- Pure HTML5 & CSS3
- Google Fonts
- Font Awesome 6.5.0 icons
- No JavaScript frameworks
