# Milestone Event Co. — Free Website Template

An elegant, editorial event planning website template. Dusty rose and champagne palette, small caps serif typography, generous whitespace. Built for wedding planners, corporate event coordinators, and full-service event companies.

## License

Free to use for any personal or commercial project. Attribution appreciated but not required.

## Quick Start

1. Download and unzip
2. Open `index.html` in your browser to preview
3. Edit content directly in the HTML files
4. Replace placeholder colors/gradients with real event photography

## Pages

- `index.html` — Homepage with hero, services overview, portfolio gallery, process, testimonials
- `about.html` — Founder story, team, philosophy, portfolio stats
- `services.html` — Full service tiers with pricing, vendor partnerships
- `contact.html` — Event inquiry form, response policy, FAQ

## Customization

### Business Details
Search and replace throughout all HTML files:
- `Milestone Event Co.` → Your company name
- `(555) 456-7890` → Your phone number
- `hello@milestoneeventco.com` → Your email

### Colors
Edit CSS variables in `styles.css` under `:root`:
- `--primary` — Dusty rose (#B07A7A)
- `--secondary` — Champagne gold (#C9A96E)
- `--accent` — Near black (#2D2D2D)
- `--bg` — Warm cream (#FDF8F5)

### Fonts
Loaded from Google Fonts:
- **Marcellus SC** — Headings (small caps)
- **Raleway** — Body text

### Portfolio Gallery
Replace the gradient placeholder blocks in the portfolio section with actual event photography. Each block is sized at 3:2 aspect ratio.

### Photos
Replace placeholder gradient divs with `<img>` tags pointing to team photos and event images.

## Built With

- Pure HTML5 & CSS3
- Google Fonts
- Font Awesome 6.5.0 icons
- No JavaScript frameworks
