# Iron Republic Fitness - Website Template

A raw, industrial, high-energy website template designed for CrossFit boxes, hardcore gyms, and fitness facilities.

## Quick Start

1. Download and extract the template files
2. Open `index.html` in your browser
3. Customize the content, colors, and images to match your gym

## Pages Included

- **Home** (`index.html`) - Hero, programs overview, differentiators, class schedule, stats, testimonials, CTA
- **About** (`about.html`) - Gym story, coaches, facility, community, philosophy
- **Programs** (`services.html`) - Detailed program descriptions, pricing, membership comparison table
- **Contact** (`contact.html`) - Free trial signup form, contact info, hours, FAQ

## Customization

### Colors

Edit the CSS custom properties in `styles.css`:

```css
:root {
  --primary: #DC2626;      /* Electric red */
  --secondary: #27272A;    /* Iron gray */
  --accent: #22C55E;       /* Neon green */
  --bg: #18181B;           /* Dark background */
  --surface: #27272A;      /* Elevated surfaces */
  --white: #FAFAFA;        /* Text color */
}
```

### Fonts

The template uses Google Fonts:
- **Teko** for headings (condensed, athletic)
- **Saira** for body text (geometric, sporty)

### Images

Replace placeholder areas with your own gym photos. Recommended image sizes:
- Hero: 1920x1080px
- Program images: 800x600px
- Coach photos: 400x400px

## Tech Stack

- Pure HTML5 and CSS3
- No JavaScript frameworks required
- Google Fonts for typography
- Font Awesome 6.5.0 for icons
- Responsive design (mobile-first)

## Browser Support

- Chrome, Firefox, Safari, Edge (latest versions)
- Mobile browsers (iOS Safari, Chrome for Android)

## License

Free for personal and commercial use. Attribution appreciated but not required.

Design by [ZADIE](https://zadie.com)
