# Harbor Shield Insurance - Insurance Agency Website Template

A stable, professional website template designed for insurance agencies, brokers, and independent agents.

## Pages

- **Home** (`index.html`) - Hero, coverage types, why choose us, testimonials, CTA
- **About** (`about.html`) - Agency story, values, team members, stats
- **Coverage** (`services.html`) - Detailed coverage options, specialty policies, quoting process
- **Contact** (`contact.html`) - Quote request form, office info, FAQ

## Design

- **Aesthetic**: Stable, professional, warm
- **Fonts**: Merriweather (headings) + Nunito (body) via Google Fonts
- **Colors**: Navy blue (#1B4F72), gold (#B8860B), off-white (#FAFBFC)
- **Icons**: Font Awesome 6.5.0

## Quick Start

1. Download and unzip the template files
2. Replace placeholder content with your business information
3. Update colors in the CSS variables section of `styles.css`
4. Replace placeholder images in the `images/` folder
5. Update contact information, hours, and location
6. Deploy to your hosting provider

## Customization

### Colors
All colors are defined as CSS custom properties in `styles.css`. Update the `:root` variables to match your brand:

```css
:root {
  --primary: #1B4F72;
  --secondary: #B8860B;
  /* ... */
}
```

### Fonts
Fonts are loaded from Google Fonts. To change fonts, update the `<link>` tag in each HTML file and the font variables in `styles.css`.

### Content
- Replace all placeholder text with your actual business content
- Update coverage types and descriptions
- Add your team photos to the `images/` folder
- Update the contact form action URL to your form handler

## Browser Support

- Chrome, Firefox, Safari, Edge (latest versions)
- Responsive design for mobile, tablet, and desktop

## License

Free for personal and commercial use. Attribution appreciated but not required.

Design by [ZADIE](https://zadie.com)
