# ClearOut Hauling Co. - Junk Removal Website Template

A bold, action-oriented website template designed for junk removal and hauling businesses. Built with pure HTML and CSS, no frameworks required.

## Quick Start

1. Download and extract the template files
2. Open `index.html` in your browser
3. Customize the content, colors, and images to match your business

## Pages

- **Home** (`index.html`) - Hero section, services overview, pricing tiers, testimonials, and call-to-action
- **About** (`about.html`) - Company story, values, team bios, and business stats
- **Services** (`services.html`) - Detailed service descriptions, item guide, pricing table, and process steps
- **Contact** (`contact.html`) - Booking form with item description field, contact sidebar, FAQ section

## Customization

### Colors

All colors are defined as CSS custom properties in `styles.css`. Update these values to match your brand:

```css
:root {
  --primary: #EA580C;       /* Bold orange */
  --primary-dark: #C2410C;
  --primary-light: #FB923C;
  --secondary: #15803D;     /* Green for eco/recycling */
  --accent: #FFF7ED;        /* Warm orange tint */
}
```

### Fonts

This template uses [Righteous](https://fonts.google.com/specimen/Righteous) for headings and [Nunito](https://fonts.google.com/specimen/Nunito) for body text, loaded via Google Fonts.

### Images

Replace the gradient placeholder backgrounds with your own photos. Look for elements with classes like `.team-photo`, `.story-image`, and `.detailed-service-image`.

### Content

Update all placeholder text, phone numbers, addresses, and pricing to reflect your actual business information.

## Technical Details

- Pure HTML5 and CSS3 (no JavaScript frameworks)
- CSS custom properties for easy theming
- Responsive design (desktop, tablet, mobile)
- Mobile hamburger menu included
- Font Awesome 6.5 icons
- Respects `prefers-reduced-motion` for accessibility

## License

Free for personal and commercial use. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
