# Swift Haul Moving Co. - Website Template

A strong, reliable website template designed for moving companies and relocation services. Deep navy and safety orange with bold uppercase typography project strength and trustworthiness.

## Pages Included

- **Home** (`index.html`) - Hero, services overview, why choose us, process steps, testimonials, coverage area, CTA
- **About** (`about.html`) - Company story, values, team profiles, stats bar
- **Services** (`services.html`) - 6 service categories with features and pricing, 3-tier moving packages
- **Contact** (`contact.html`) - Quote request form with move details, contact info, hours, emergency moves, FAQ

## Quick Start

1. Replace placeholder content with your business information
2. Update colors in the `:root` CSS variables in `styles.css`
3. Add your own team photos to replace placeholder areas
4. Update phone numbers, addresses, and email throughout
5. Connect the contact form to your preferred form handler
6. Replace coverage area cards with your actual service zones

## Customization

### Colors
Edit CSS custom properties in `styles.css`:

```css
:root {
  --primary: #1B365D;      /* Deep navy */
  --secondary: #E8702A;    /* Safety orange */
  --gray-light: #F5F6F8;   /* Light background */
}
```

### Fonts
Template uses Google Fonts:
- **Headings**: Big Shoulders Display
- **Body**: Public Sans

### Images
Replace placeholder areas with your own images:
- Hero background (moving crew loading truck)
- About page story image
- Team photos

## Features

- Fully responsive (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS custom properties for easy theming
- Font Awesome 6.5.0 icons
- Hover animations and transitions
- 4-step process visualization
- 3-tier pricing comparison
- Quote request form with move type and size fields
- Coverage area display
- Emergency moves contact section
- Accessibility-friendly (reduced motion support, ARIA labels)

## Tech Stack

- Pure HTML5 and CSS3
- No JavaScript frameworks
- Google Fonts
- Font Awesome icons
- CSS Grid and Flexbox layouts

## License

Free for personal and commercial use. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
