# GuardLine Pest Solutions - Website Template

A clean, professional website template designed for pest control companies and extermination services. Built with a reassuring, science-forward aesthetic that instills confidence in homeowners.

## Pages Included

- **Home** (`index.html`) - Hero, common pests, process, features, stats, testimonials, emergency banner, CTA
- **About** (`about.html`) - Company story, team, IPM approach, certifications, safety commitment
- **Services** (`services.html`) - 6 service categories with pricing, 3-tier annual protection plans
- **Contact** (`contact.html`) - Service request form, contact info, service area map, FAQ

## Quick Start

1. Replace placeholder content with your business information
2. Update colors in the `:root` CSS variables in `styles.css`
3. Add your Google Maps embed to the map container on the contact page
4. Replace team initials with actual photos
5. Update phone numbers, addresses, and email throughout
6. Connect the contact form to your preferred form handler

## Customization

### Colors
Edit CSS custom properties in `styles.css`:

```css
:root {
  --primary: #166534;      /* Forest green */
  --secondary: #1E293B;    /* Dark navy */
  --accent: #65A30D;       /* Lime green */
  --light-bg: #F0FDF4;     /* Light green tint */
}
```

### Fonts
Template uses Google Fonts:
- **Headings**: Exo 2
- **Body**: Nunito Sans

### Images
Replace placeholder areas with your own images:
- Hero background
- Story/about image
- Team photos (currently using initials)
- Service area map

## Features

- Fully responsive (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS custom properties for easy theming
- Font Awesome 6.5.0 icons
- Hover animations and transitions
- Emergency call banner
- Service request form with pest type and urgency dropdowns
- 3-tier pricing plan layout
- FAQ section
- Accessibility-friendly (reduced motion support, ARIA labels)

## Tech Stack

- Pure HTML5 and CSS3
- No JavaScript frameworks
- Google Fonts
- Font Awesome icons
- CSS Grid and Flexbox layouts

## License

Free for personal and commercial use. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
