# Restore Motion PT - Website Template

A professional website template designed for physical therapy clinics and rehabilitation practices. Built with an active, healing aesthetic that conveys expertise and patient-first care.

## Pages Included

- **Home** (`index.html`) - Hero, services overview, why choose us, process steps, testimonials, CTA
- **About** (`about.html`) - Company story, values, team, stats bar
- **Services** (`services.html`) - 6 detailed service cards with pricing, 3-tier session packages
- **Contact** (`contact.html`) - Appointment booking form, contact info, insurance list, FAQ

## Quick Start

1. Replace placeholder content with your clinic's information
2. Update colors in the `:root` CSS variables in `styles.css`
3. Replace team initials with actual staff photos
4. Update phone numbers, addresses, and email throughout
5. Add your accepted insurance plans to the contact page
6. Connect the contact form to your preferred form handler

## Customization

### Colors
Edit CSS custom properties in `styles.css`:

```css
:root {
  --primary: #0891B2;      /* Active teal */
  --secondary: #1E293B;    /* Dark slate */
  --accent: #F59E0B;       /* Warm amber */
  --light-bg: #F0F9FF;     /* Light sky tint */
}
```

### Fonts
Template uses Google Fonts:
- **Headings**: Urbanist
- **Body**: Figtree

### Images
Replace placeholder areas with your own images:
- Hero background
- Story/clinic photo
- Team photos (currently using initials)

## Features

- Fully responsive (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS custom properties for easy theming
- Font Awesome 6.5.0 icons
- Hover animations and transitions
- Insurance info card
- Appointment booking form with referral type and preferred time
- 3-tier pricing package layout
- FAQ section
- Accessibility-friendly (reduced motion support, ARIA labels)

## Tech Stack

- Pure HTML5 and CSS3
- No JavaScript frameworks
- Google Fonts
- Font Awesome icons
- CSS Grid and Flexbox layouts

## License

Free for personal and commercial use. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
