# PowerClean Exteriors - Pressure Washing Website Template

A bold, high-impact website template designed for pressure washing and power washing businesses. Features a water-themed aesthetic with strong blues and greens, realistic service content with pricing, and a quote request form with property type and surface selectors.

## Pages

- **Home** (`index.html`) - Hero with water drop animation, 6 service cards, why choose us, testimonials, CTA
- **About** (`about.html`) - Company story, 3 core values, team section, business stats
- **Services** (`services.html`) - 4 detailed services with pricing, 6 additional service cards, 4-step process
- **Contact** (`contact.html`) - Quote request form with property/surface selectors, sidebar with contact info and hours, 6 FAQs

## Quick Start

1. Replace placeholder content with your business details
2. Update phone number, email, and address across all pages
3. Add your own photos to the `images/` directory and update image references
4. Update Google Analytics ID or remove the analytics code
5. Customize colors in `styles.css` CSS variables

## Customization

### Colors
All colors are defined as CSS custom properties in `:root`. Key variables:
- `--primary`: Water blue (#0369A1)
- `--secondary`: Clean green (#16A34A)
- `--accent`: Ice blue tint (#F0F9FF)

### Fonts
- **Headings**: Kanit (loaded from Google Fonts)
- **Body**: Barlow (loaded from Google Fonts)

### Images
Photo placeholders use CSS gradients. Replace with actual images by adding `<img>` tags or updating the background properties.

## Technical Details

- Pure HTML5 and CSS3 (no JavaScript frameworks)
- CSS Custom Properties for easy theming
- Responsive design (1024px, 768px, 480px breakpoints)
- Mobile hamburger menu on all pages
- `prefers-reduced-motion` support for accessibility
- Font Awesome 6.5 for icons

## License

Free for personal and commercial use. Attribution link appreciated but not required.