# Rapid Response Towing - Free Website Template

A professional, mobile-responsive website template designed for towing companies and roadside assistance businesses. Built with pure HTML5 and CSS3.

## Pages Included

- **Home** (`index.html`) - Hero with prominent phone number, services overview, response time guarantee, testimonials, and call-to-action
- **About** (`about.html`) - Company story, core values, fleet showcase, and company stats
- **Services** (`services.html`) - Detailed towing services, roadside assistance cards, service area, and transparent pricing
- **Contact** (`contact.html`) - Service request form with vehicle details, dispatch card, contact info sidebar, and FAQ

## Features

- Fully responsive design (desktop, tablet, mobile)
- Mobile hamburger navigation menu
- Emergency dispatch bar with click-to-call
- CSS custom properties for easy color/font customization
- Google Fonts (Signika + Source Sans 3)
- Font Awesome icons
- No JavaScript frameworks required
- Reduced motion support for accessibility
- Gradient-based image placeholders (no external images needed)

## Quick Start

1. Download or clone this template
2. Replace placeholder content with your business information
3. Update the phone number `(555) 123-4567` throughout all pages
4. Add your own images to the `images/` directory
5. Deploy to any static hosting provider

## Customization

### Colors

Edit the CSS variables in `styles.css`:

```css
:root {
  --primary: #B91C1C;      /* Emergency red */
  --secondary: #F59E0B;    /* Caution amber */
  --accent: #FEF2F2;       /* Light red tint */
}
```

### Fonts

The template uses Google Fonts loaded in each HTML file:

- **Headings**: Signika
- **Body**: Source Sans 3

### Phone Number

Search and replace `(555) 123-4567` and `+15551234567` across all HTML files with your actual business number.

## License

Free for personal and commercial use. Attribution appreciated but not required.

## Credits

Design by [ZADIE](https://zadie.com)
