# The Evergreen Estate - Wedding Venue Website Template

A romantic, elegant website template designed for wedding venues, event estates, and celebration spaces. Features warm stone and champagne gold tones with refined typography that conveys timeless luxury.

## Quick Start

1. Download and unzip the template files
2. Open `index.html` in your browser to preview
3. Edit the HTML files to add your venue's information
4. Replace placeholder colors with your own photos
5. Upload to your hosting provider

## Pages

- **Home** (`index.html`) - Hero section, venue highlights, services overview, testimonials, and call-to-action
- **About** (`about.html`) - Estate story, values, team profiles, and stats
- **Venues & Packages** (`services.html`) - Venue space details, wedding packages with pricing, amenities, and planning process
- **Contact** (`contact.html`) - Tour request form, contact information, hours, and FAQ

## Customization

### Colors

Edit the CSS custom properties in `styles.css` under `:root`:

```css
--primary: #78716C;      /* Warm stone */
--secondary: #C9956B;    /* Champagne gold */
--accent: #FAF9F6;       /* Warm ivory */
```

### Fonts

The template uses [Italiana](https://fonts.google.com/specimen/Italiana) for headings and [Raleway](https://fonts.google.com/specimen/Raleway) for body text, loaded via Google Fonts.

### Images

Image placeholder areas use CSS background gradients. Replace them with your own photos by changing the `background` property to a `background-image: url(...)` pointing to your image files.

### Content

All content is written directly in the HTML files. Search for venue names, pricing, and contact details to replace with your own information.

## Features

- Fully responsive (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS-only FAQ accordion
- No JavaScript frameworks required
- Google Fonts for distinctive typography
- Font Awesome icons
- CSS custom properties for easy theming
- Accessible navigation and form labels
- Reduced motion support

## Tech Stack

- HTML5
- CSS3 (Custom Properties, Grid, Flexbox)
- Vanilla JavaScript (mobile menu and FAQ only)
- Google Fonts
- Font Awesome 6

## Browser Support

Tested in modern browsers: Chrome, Firefox, Safari, and Edge.

## License

Free for personal and commercial use. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
